/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 2004 Adobe Systems Incorporated                       */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/


/*
**-----------------------------------------------------------------------------
** Effect File Variables
**-----------------------------------------------------------------------------
*/

uniform float4x4	gWorldViewProj : WorldViewProjection; // This matrix will be loaded by the application
uniform float4x4	gWorldViewInverse;
uniform float4x4	gWorldView;
uniform float4x4	gWorld;
uniform float4x4	gViewProj;
uniform float		gAspectRatio;
uniform float4x4	gTransformMat;
uniform float3		gLookAtVector = float3(0.0f,0.0f,1.0f); //const vector used to determine the texcoordinate set to use
uniform float		gTranslateX;
uniform float		gTranslateY;

texture				gVideoTextureA;
texture				gVideoTextureB;


/*
**-----------------------------------------
**		Sampler States
**-----------------------------------------
*/
//incoming video texture A
sampler SamplerA = sampler_state
{
    Texture   = (gVideoTextureA);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};
//incoming video texture B
sampler SamplerB = sampler_state
{
    Texture   = (gVideoTextureB);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};
/*
**-----------------------------------------------------------------------------
** Vertex Definitions
**-----------------------------------------------------------------------------
** APP_OUTPUT is the structure in which we receive the vertices from the application
*/
struct APP_OUTPUT
{
    float3 mPosition	: POSITION;
	float3 mNormal		: NORMAL;
	float2 mTexCoordA	: TEXCOORD0;
	float2 mTexCoordB	: TEXCOORD1;

};

/* 
** Pixel Shader structure declaration 
*/
struct VS_OUTPUT 
{
	float4 mHPosition		: POSITION;		// coord position in window
	float2 mTexcoordA		: TEXCOORD0;	// texture coordinates
	float2 mTexcoordB		: TEXCOORD1;
	float  mFlag			: TEXCOORD2;
};

/*
**-------------------------------------------------------------------------
** Spiral Flip Transition effect - Vertex Shader
**-------------------------------------------------------------------------
*/
VS_OUTPUT spiralflip_vs(APP_OUTPUT In)
{
	VS_OUTPUT Out;

	// copy texture coordinates
	Out.mTexcoordA.xy = In.mTexCoordA.xy;
	Out.mTexcoordB.xy = In.mTexCoordB.xy;
	
	// transform vertex position into homogenous clip-space
	Out.mHPosition = mul(gWorldViewProj,mul(gTransformMat,float4(In.mPosition.x*gAspectRatio,In.mPosition.y,In.mPosition.z,1.0f)));

	//Translating by a factor to take care of DirectX error which shifts by half pixel
	Out.mHPosition.xy -= float2( gTranslateX, -gTranslateY );
	
	// transform the normal accordingly
	float3 normal = mul(gTransformMat,mul(gWorldView,float4(In.mNormal.xyz,1.0f)));
	
	// this flag determines which side the normal is, in turn used to pick up the appropriate texcoordinate set
	Out.mFlag = 0.0f;
	float normalDir = dot(float3(0,0,normal.z),gLookAtVector);
	if(normalDir<=0.0f)
	{
		Out.mFlag = 1.0f;
	}
	return Out;
}


/*
**-------------------------------------------------------------------------
** Spiral Flip Transition effect - pixel Shader 1_3
**-------------------------------------------------------------------------
*/

float4 spiralflip_ps(VS_OUTPUT In) : COLOR
{   
	float4 color1 = tex2D( SamplerA, In.mTexcoordA );
	float4 color2 = tex2D( SamplerB, In.mTexcoordB );
	float4 color = lerp(color1,color2,In.mFlag);
	return color;
}

technique spiralflip_transition_1_3
{
    pass Pass0
    {
		Sampler[0] = (SamplerA);
		Sampler[1] = (SamplerB);
	
		VertexShader = compile vs_1_1 spiralflip_vs();
		PixelShader  = compile ps_1_1 spiralflip_ps();
		//[NOTE] anroy 07/29/04: ps_1_3 was causing problems on PS1.4 cards.
		//so we changed it to ps_1_1, which seems to work for all cards tested.
		
    }
}
